% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressliu.R
\name{pressliu}
\alias{pressliu}
\title{Predicted Residual Sum of Squares (PRESS)}
\usage{
pressliu(obj, digits = 5L, ...)
}
\arguments{
\item{obj}{A \code{liureg} object.}

\item{digits}{Decimal places in the columns of data frame of PRESS values.
Can be an integer of vector of integers.}

\item{...}{Not used in this implementation.}
}
\value{
The returned object is a vector of PRESS values computed for each \code{lambda.}.
}
\description{
\code{pressliu} computes the predicted residual sum of squares (PRESS) based on a
Liu regression model.
}
\details{
The PRESS statistic is based on the predicted leave-one-out residual sum of squares.
The statistic is computed as \eqn{{\sum\limits _{i=1}^{n}\left(\frac{\hat{e}_{\lambda i}}{1-h_{1-ii}}-\frac{e_{i}\left(h_{1-ii}-\tilde{\mathbf{H}}_{\lambda-ii}\right)}{\left(1-h_{1-ii}\right)\left(1-h_{ii}\right)}\right)^{2}}}
where \eqn{h_{ii}} is the \eqn{i}th diagonal element of the hat matrix corresponding
to the least squares estimator, \eqn{h_{1-ii}} is the \eqn{i}th diagonal
element of the hat matrix of the Liu estimator and \eqn{e_{\lambda i}}
is the residual at the specific value of \eqn{\lambda}.
}
\examples{
data("Hitters")
Hitters <- na.omit(Hitters)
X <- model.matrix(Salary ~ ., Hitters)[, -1]
y <- Hitters$Salary
lam <- seq(0, 1, 0.01)
liu.mod <- liureg(X, y, lam)
pressliu(liu.mod)
}
\references{
Liu, K. (1993). A new class of blased estimate in linear regression.
\emph{Communications in Statistics-Theory and Methods}, \strong{22}(2), 393-402.
\doi{10.1080/03610929308831027}.

Ozkale, M. R. and Kaciranlar, S. (2007). A prediction-oriented
criterion for choosing the biasing parameter in Liu estimation.
\emph{Communications in Statistics-Theory and Methods}, \strong{36}(10), 1889-1903.
\doi{10.1080/03610920601126522}.
}
\seealso{
\code{\link[=liureg]{liureg()}}, \code{\link[=pressliu]{pressliu()}}, \code{\link[=residuals]{residuals()}}
}
\author{
Murat Genç, Ömer Özbilen
}
