.bt.results <- function(x, alpha) {
  #' bt.results
  #'
  #' Collects the bootstrap results and yields the bootstrapped mean, standard 
  #' error, and confidence intervals
  #'
  #' @param x = Vector with the bootstrap repetitions of an estimator
  #' @param alpha = Set of significance levels to be returned
  #'
  #' @return m = Bootstrapped mean
  #' @return se = Bootstrapped standard error
  #' @return ub = Upper bound of the bootstrapped confidence interval
  #' @return lb = Lower bound of the bootstrapped confidence interval
  
  Na <- length(alpha)
  
  m <- mean(x)
  
  se <- ((stats::quantile(x - m, 0.75) - stats::quantile(x - m, 0.25)) / 
           (stats::qnorm(0.75) - stats::qnorm(0.25)))
  
  ub <- numeric(Na)
  lb <- numeric(Na)
  for (i in 1:Na) {
    ub[i] <- stats::quantile(x, 1 - alpha[i] / 2)
    lb[i] <- stats::quantile(x, alpha[i] / 2)
  }
  
    list(m = m, se = se, ub = ub, lb = lb)
  }