% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_binomial.R
\name{extract_binomial}
\alias{extract_binomial}
\title{Extract the binomial name (Genus + specific epithet) from a Scientific Name}
\usage{
extract_binomial(species_names)
}
\arguments{
\item{species_names}{(character) Scientific names to be converted to
binomial names}
}
\value{
A vector with the binomial names (Genus + specific epithet).
}
\description{
Extract the binomial name (Genus + specific epithet) from a Scientific Name
}
\examples{
spp <- c("Panthera onca (Linnaeus, 1758)",
"Zonotrichia capensis subtorquata Swainson, 1837",
"Paraganaspis egeria Díaz & Gallardo, 1996",
"Arrenurus tumulosus intercursor")
spp_new <- extract_binomial(species_names = spp)
spp_new

}
