% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts.R
\name{contr_code_anova}
\alias{contr_code_anova}
\title{Anova code a factor}
\usage{
contr_code_anova(fct, levels = NULL, base = 1, colnames = NULL)
}
\arguments{
\item{fct}{the factor to contrast code (or a vector)}

\item{levels}{the levels of the factor in order}

\item{base}{the index of the level to use as baseline}

\item{colnames}{optional list of column names for the added contrasts}
}
\value{
the factor with contrasts set
}
\description{
Anova coding (also called deviation or simple coding) sets the grand mean as the intercept. 
Each contrast compares one level with the reference level (base).
}
\examples{
df <- sim_design(between = list(pet = c("cat", "dog")), 
                 mu = c(10, 20), plot = FALSE)
df$pet <- contr_code_anova(df$pet)
lm(y ~ pet, df) \%>\% broom::tidy()

df <- sim_design(between = list(pet = c("cat", "dog", "ferret")), 
                 mu = c(2, 4, 9), empirical = TRUE, plot = FALSE)
                 
df$pet <- contr_code_anova(df$pet, base = 1)
lm(y ~ pet, df) \%>\% broom::tidy()

df$pet <- contr_code_anova(df$pet, base = 2)
lm(y ~ pet, df) \%>\% broom::tidy()

df$pet <- contr_code_anova(df$pet, base = "ferret")
lm(y ~ pet, df) \%>\% broom::tidy()
}
