% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe.r
\name{\%>\%}
\alias{\%>\%}
\title{Forward-pipe Operator Using Standard Evaluation}
\usage{
lhs \%>\% rhs
}
\arguments{
\item{lhs}{the function that will be applied second to an input.}

\item{rhs}{the function that will be applied first to an input.}
}
\value{
The composed function lhs(rhs(x)).
}
\description{
The forward pipe operator behaves similar to the magrittr
pipe operator with two exceptions. First, it only supports standard
evaluation. If modified parameter values are needed
then the 'fc' function should be used. Second, it composes functions.
The return type of this operator is an R function.
}
\examples{
# Create a new code block in case the pipe operator is already
# defined.
{
  # Make sure the example uses the correct pipe operator.
  `\%>\%` <- fc::`\%>\%`

 # Create a function that gets the 9th and 10th objects using the head
 # and tail functions.
 nine_and_ten <- fc(head, n=10) \%>\% fc(tail, n=2)
 nine_and_ten(iris)
}
}
