% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexible_cfdr.R
\name{flexible_cfdr}
\alias{flexible_cfdr}
\title{Perform Flexible cFDR}
\usage{
flexible_cfdr(
  p,
  q,
  indep_index,
  res_p = 300,
  res_q = 500,
  nxbin = 1000,
  gridp = 50,
  splinecorr = TRUE,
  dist_thr = 0.5,
  locfdr_df = 10,
  plot = TRUE,
  maf = NULL,
  check_indep_cor = TRUE,
  enforce_p_q_cor = TRUE
)
}
\arguments{
\item{p}{p-values for principal trait (vector of length n)}

\item{q}{continuous auxiliary data values (vector of length n)}

\item{indep_index}{indices of independent SNPs}

\item{res_p}{number of grid points in x-direction (\code{p}) for KDE estimation}

\item{res_q}{number of grid points in y-direction (\code{q}) for KDE estimation}

\item{nxbin}{number of bins in x-direction (\code{p}) for hex-binning}

\item{gridp}{number of data points required in a KDE grid point for left-censoring}

\item{splinecorr}{logical value for whether spline correction should be implemented}

\item{dist_thr}{distance threshold for spline correction}

\item{locfdr_df}{\code{df} parameter in locfdr function}

\item{plot}{logical value for whether to produce plots to assess KDE fit}

\item{maf}{minor allele frequencies for SNPs to which \code{p} and \code{q} relate (optional and used to perform MAF matching)}

\item{check_indep_cor}{check that sign of the correlation between \code{p} and \code{q} is the same in the independent subset as in the whole}

\item{enforce_p_q_cor}{if \code{p} and \code{q} are negatively correlated, flip the sign on \code{q} values}
}
\value{
List of length two: (1) data.frame of p-values, q-values and v-values (2) data.frame of auxiliary data (q_low used for left censoring, how many data-points were left censored and/or spline corrected)
}
\description{
Performs Flexible cFDR for continuous auxiliary covariates
}
\details{
If \code{maf} is specified, then the independent SNPs will be down-sampled to match the minor allele frequency distribution.
}
\examples{
\donttest{
# this is a long running example
 
# In this example, we generate some p-values (representing GWAS p-values)
# and some arbitrary auxiliary data values (e.g. representing functional genomic data).
# We use the flexible_cfdr() function to generate v-values using default parameter values.

# generate p
set.seed(1)
n <- 1000
n1p <- 50 
zp <- c(rnorm(n1p, sd=5), rnorm(n-n1p, sd=1))
p <- 2*pnorm(-abs(zp))

# generate q
mixture_comp1 <- function(x) rnorm(x, mean = -0.5, sd = 0.5)
mixture_comp2 <- function(x) rnorm(x, mean = 2, sd = 1)
q <- c(mixture_comp1(n1p), mixture_comp2(n-n1p))

n_indep <- n

flexible_cfdr(p, q, indep_index = 1:n_indep)
}

}
