% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_filter.R
\name{ft_filter_pos}
\alias{ft_filter_pos}
\title{Remove Factor Levels with Specific Characters at Specified Positions}
\usage{
ft_filter_pos(
  factor_vec,
  positions = NULL,
  char,
  case = FALSE,
  remove_na = TRUE,
  invert = FALSE,
  .return = FALSE
)
}
\arguments{
\item{factor_vec}{A factor vector from which levels will be removed.}

\item{positions}{A vector of positive integers indicating the character positions to check.}

\item{char}{A single character string specifying the character to look for.}

\item{case}{Logical. Should the character matching be case-sensitive? Default is \code{FALSE}.}

\item{remove_na}{remove NA from the output? Default is \code{TRUE}.}

\item{invert}{logical. If TRUE return indices or values for elements that do not match.}

\item{.return}{logical. If TRUE return TRUE or FALSE instead of element.}
}
\value{
A factor vector with levels removed where the specified character appears at the specified positions.
}
\description{
Removes factor levels where a specified character appears at specified positions within the levels.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple', 'banana', 'apricot', 'cherry', 'date', 'fig', 'grape'))

# Remove levels where 'a' appears at position 1
ft_filter_pos(factor_vec, positions = 1, char = 'a')

# Remove levels where 'e' appears at positions 2 or 3
ft_filter_pos(factor_vec, positions = c(2, 3), char = 'e')

# Case-sensitive removal
factor_vec_case <- factor(c('Apple', 'banana', 'Apricot', 'Cherry', 'Date', 'Fig', 'grape'))
ft_filter_pos(factor_vec_case, positions = 1, char = 'A', case = TRUE)
}
\author{
Kai Guo
}
