% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_autocorrelation.R
\name{FTS_identification}
\alias{FTS_identification}
\title{Obtain the auto- and partial autocorrelation functions for a given FTS}
\usage{
FTS_identification(Y, v, nlags, n_harm = NULL, ci = 0.95,
  estimation = "MC", figure = TRUE, ...)
}
\arguments{
\item{Y}{Matrix containing the discretized values
of the functional time series. The dimension of the
matrix is \eqn{(n x m)}, where \eqn{n} is the
number of curves and \eqn{m} is the number of points
observed in each curve.}

\item{v}{Discretization points of the curves.}

\item{nlags}{Number of lagged covariance operators
of the functional time series that will be used
to estimate the autocorrelation functions.}

\item{n_harm}{Number of principal components
that will be used to fit the ARH(p) models. If
this value is not supplied, \code{n_harm} will be
selected as the number of principal components that
explain more than 95 \% of the variance of the
original data.
By default, \code{n_harm = NULL}.}

\item{ci}{A value between 0 and 1 that indicates
the confidence interval for the i.i.d. bounds
of the partial autocorrelation function. By default
\code{ci = 0.95}.}

\item{estimation}{Character specifying the
method to be used when estimating the distribution
under the hypothesis of functional white noise.
Accepted values are:
\itemize{
   \item "MC": Monte-Carlo estimation.
   \item "Imhof": Estimation using Imhof's method.
}
By default, \code{estimation = "MC"}.}

\item{figure}{Logical. If \code{TRUE}, plots the
estimated partial autocorrelation function with the
specified i.i.d. bound.}

\item{...}{Further arguments passed to the \code{plot_FACF}
function.}
}
\value{
Return a list with:
\itemize{
    \item \code{Blueline}: The upper prediction
    bound for the i.i.d. distribution.
    \item \code{rho_FACF}: Autocorrelation
    coefficients for
    each lag of the functional time series.
    \item \code{rho_FPACF}: Partial autocorrelation
    coefficients for
    each lag of the functional time series.
}
}
\description{
Estimate both the autocorrelation and partial 
autocorrelation function for a given functional time series 
and its distribution under the hypothesis of strong functional
white noise. Both correlograms are plotted to ease the identification
of the dependence structure of the functional time series.
}
\examples{
# Example 1 (Toy example)

N <- 50
v <- seq(from = 0, to = 1, length.out = 10)
sig <- 2
set.seed(15)
Y <- simulate_iid_brownian_bridge(N, v, sig)
FTS_identification(Y,v,3)

\donttest{
# Example 2

data(elec_prices)
v <- seq(from = 1, to = 24)
nlags <- 30
FTS_identification(Y = as.matrix(elec_prices), 
v = v,
nlags = nlags,
ci = 0.95,
figure = TRUE)
}
}
\references{
Mestre G., Portela J., Rice G., Muñoz San Roque A., Alonso E. (2021).
\emph{Functional time series model identification and diagnosis by 
means of auto- and partial autocorrelation analysis.}
Computational Statistics & Data Analysis, 155, 107108.
\url{https://doi.org/10.1016/j.csda.2020.107108}

Mestre, G., Portela, J., Muñoz-San Roque, A., Alonso, E. (2020).
\emph{Forecasting hourly supply curves in the Italian Day-Ahead 
electricity market with a double-seasonal SARMAHX model.}
International Journal of Electrical Power & Energy Systems, 
121, 106083. \url{https://doi.org/10.1016/j.ijepes.2020.106083}

Kokoszka, P., Rice, G., Shang, H.L. (2017).
\emph{Inference for the autocovariance of a functional
 time series under conditional heteroscedasticity}
Journal of Multivariate Analysis, 
162, 32--50. \url{https://doi.org/10.1016/j.jmva.2017.08.004}
}
