% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tolerance.R
\name{bootTB}
\alias{bootTB}
\title{Tolerance Bound Calculation using Bootstrap Sampling}
\usage{
bootTB(
  f,
  time,
  a = 0.05,
  p = 0.99,
  B = 500,
  no = 5,
  Nsamp = 100,
  parallel = TRUE
)
}
\arguments{
\item{f}{matrix of functions}

\item{time}{vector describing time sampling}

\item{a}{confidence level of tolerance bound (default = 0.05)}

\item{p}{coverage level of tolerance bound (default = 0.99)}

\item{B}{number of bootstrap samples (default = 500)}

\item{no}{number of principal components (default = 5)}

\item{Nsamp}{number of functions per bootstrap (default = 100)}

\item{parallel}{enable parallel processing (default = TRUE)}
}
\value{
Returns a list containing \item{amp}{amplitude tolerance bounds}
\item{ph}{phase tolerance bounds}
}
\description{
This function computes tolerance bounds for functional data containing
phase and amplitude variation using bootstrap sampling
}
\examples{
\dontrun{
  out1 <- bootTB(simu_data$f, simu_data$time)
}
}
\references{
J. D. Tucker, J. R. Lewis, C. King, and S. Kurtek, “A Geometric
Approach for Computing Tolerance Bounds for Elastic Functional Data,”
Journal of Applied Statistics, 10.1080/02664763.2019.1645818, 2019.

Tucker, J. D., Wu, W., Srivastava, A., Generative Models for
Function Data using Phase and Amplitude Separation, Computational
Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.

Jung, S. L. a. S. (2016). "Combined Analysis of Amplitude and
Phase Variations in Functional Data." arXiv:1603.01775.
}
\concept{bounds}
\keyword{bootstrap}
\keyword{tolerance}
