% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactoring.R
\name{get_warping_distance}
\alias{get_warping_distance}
\title{Computes the distance between two warping functions}
\usage{
get_warping_distance(gam1fun, gam2fun)
}
\arguments{
\item{gam1fun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of the first warping function
at \eqn{s}.}

\item{gam2fun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of the second warping function
at \eqn{s}.}
}
\value{
A numeric value storing the distance between the two warping
functions.
}
\description{
Computes the distance between two warping functions
}
\examples{
gam1 <- discrete2warping(toy_warp$gam[, 1])
gam2 <- discrete2warping(toy_warp$gam[, 2])
get_warping_distance(gam1, gam2)
get_warping_distance(gam1, get_identity_warping())
}
