% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddm_methods.R
\name{ddm-methods}
\alias{ddm-methods}
\alias{print.ddm}
\alias{summary.ddm}
\alias{print.summary.ddm}
\alias{coef.ddm}
\alias{vcov.ddm}
\alias{model.frame.ddm}
\alias{model.matrix.ddm}
\alias{terms.ddm}
\alias{logLik.ddm}
\alias{update.ddm}
\alias{recover_data.ddm}
\alias{emm_basis.ddm}
\title{Methods for ddm objects}
\usage{
\method{print}{ddm}(x, digits = max(3, getOption("digits") - 3), ...)

\method{summary}{ddm}(object, ...)

\method{print}{summary.ddm}(x, digits = max(3, getOption("digits") - 3), ...)

\method{coef}{ddm}(object, dpar = c("drift", "boundary", "ndt", "bias", "sv", "full"), ...)

\method{vcov}{ddm}(object, dpar = c("drift", "boundary", "ndt", "bias", "sv"), ...)

\method{model.frame}{ddm}(formula, ...)

\method{model.matrix}{ddm}(object, dpar = c("drift", "boundary", "ndt", "bias", "sv"), ...)

\method{terms}{ddm}(x, dpar = c("drift", "boundary", "ndt", "bias", "sv"), ...)

\method{logLik}{ddm}(object, ...)

\method{update}{ddm}(object, ...)

recover_data.ddm(object, data, ...)

emm_basis.ddm(
  object,
  trms,
  xlev,
  grid,
  dpar = c("drift", "boundary", "ndt", "bias", "sv"),
  ...
)
}
\arguments{
\item{digits}{minimal number of significant digits, see
\code{\link{print.default}}.}

\item{...}{further arguments passed to or from other methods.}

\item{object, x}{object of class \code{ddm}}

\item{dpar}{which distributional parameter or DDM parameter to focus on. In
addition to the five DDM parameters \code{c("drift", "boundary", "ndt",
  "bias", "sv")}, some methods accept \code{"full"} which returns information
for all estimated parameters.}

\item{formula}{see \code{\link{model.frame}}}

\item{data, trms, xlev, grid}{arguments needed for \pkg{emmeans} support.}
}
\description{
Implemented S3 methods for objects of class \code{ddm} as returned by
function \code{\link{ddm}()}.
}
\details{
The methods should fail with an informative error if a
distributional parameter is selected in \code{dpar} that is fixed and not
estimated.
}
