% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cyclical_cos}
\alias{cyclical_cos}
\title{Convert a Cyclical Variable to Cosine Representation}
\usage{
cyclical_cos(x, period)
}
\arguments{
\item{x}{A numeric vector representing a cyclic variable (e.g., hour, month, day).}

\item{period}{A positive numeric scalar representing the period of the cycle.
For example, use 24 for hours of the day, 7 for days of the week, and 12 for months.}
}
\value{
A numeric vector representing the cosine-transformed values.
}
\description{
This function transforms a cyclic variable (e.g., hour of the day, day of the week, month of the year)
into its cosine representation. This transformation ensures that machine learning models respect
the cyclical nature of such features.
}
\details{
This function applies the transformation:
  \deqn{cos(2 * \pi * x / period)}
  This encoding ensures that the first and last values in the cycle are smoothly connected.
}
\examples{
# Convert hours of the day to cosine encoding
hours <- 0:23
cyclical_cos(hours, 24)

# Convert months of the year to cosine encoding
months <- 1:12
cyclical_cos(months, 12)

}
