% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_flag-time_period.R
\name{is_enabled.time_period_feature_flag}
\alias{is_enabled.time_period_feature_flag}
\title{Checks if the given bool feature flag is enabled}
\usage{
\method{is_enabled}{time_period_feature_flag}(feature_flag)
}
\arguments{
\item{feature_flag}{flag to be checked whether it is
enabled}
}
\value{
TRUE if the feature flag is enabled.
}
\description{
Checks if the given bool feature flag is enabled
}
\examples{
{
  feature_flag <- create_time_period_feature_flag(
    from = ISOdatetime(2020, 10, 10, 0, 0, 0, tz = "UTC")
  )

  if (is_enabled(feature_flag)) {
    print("The flag is enabled!")
  }
}
}
