% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specs.R
\encoding{UTF-8}
\name{read.specs}
\alias{read.specs}
\title{Read import specs from the file system}
\usage{
read.specs(file_path = getwd())
}
\arguments{
\item{file_path}{The full or relative path to the file system.  Default is
the current working directory. If the \code{file_path} is a file name that 
does not contain the '.specs' file extension, the function will add the
extension.  If the \code{file_path} contains a directory name, 
the function will search the directory for a file with an extension 
of '.specs'.  If more than one file with an extension of '.specs' is founds, 
the function will generate an error.}
}
\value{
The specifications object.
}
\description{
A function to read import specifications from the file system.
The function accepts a full or relative path to the spec file, and returns
the specs as an object.  If the \code{file_path} parameter is passed
as a directory name, the function will search for a file with a '.specs'
extension and read it.
}
\seealso{
Other specs: 
\code{\link{import_spec}()},
\code{\link{print.specs}()},
\code{\link{specs}()},
\code{\link{write.specs}()}
}
\concept{specs}
