% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs_filter.R
\name{wfs_filter}
\alias{wfs_filter}
\title{WFS filters}
\usage{
wfs_filter(
  ...,
  filter = NULL,
  bbox = NULL,
  poly = NULL,
  predicate = "intersects",
  geom_property = "geom",
  default_crs = 25832,
  lang = NULL
)
}
\arguments{
\item{...}{Used to construct CQL filters. Dot arguments accept an R-like
syntax that is converted to CQL queries internally. These queries basically
consist of a property name on the left, an aribtrary vector on the right,
and an operator that links both sides. If multiple queries are provided,
they will be chained with \code{AND}. The following operators and their
respective equivalents in CQL and XML are supported:

\tabular{lll}{
\strong{R} \tab \strong{CQL} \tab \strong{XML}\cr
\code{==} \tab \code{=} \tab \code{PropertyIsEqualTo}\cr
\code{!=} \tab \code{<>} \tab \code{PropertyIsNotEqualTo}\cr
\code{<} \tab \code{<} \tab \code{PropertyIsLessThan}\cr
\code{>} \tab \code{>} \tab \code{PropertyIsGreaterThan}\cr
\code{>=} \tab \code{>=} \tab \code{PropertyIsGreaterThanOrEqualTo}\cr
\code{<=} \tab \code{<=} \tab \code{PropertyIsLessThanOrEqualTo}\cr
\code{\%LIKE\%} \tab \code{LIKE} \tab \code{PropertyIsLike}\cr
\code{\%ILIKE\%} \tab \code{ILIKE} \tab\cr
\code{\%in\%} \tab \code{IN} \tab \code{PropertyIsEqualTo} and \code{Or}
}

To construct more complex queries, you can use the \code{filter} argument
to pass CQL queries directly. Also note that you can switch between
CQL and XML queries using \code{options(ffm_query_language = "xml")}.
See also \code{\link{wfs_filter}}.}

\item{filter}{A character string containing a valid CQL or XML filter. This
string is appended to the query constructed through \code{...}. Use this
argument to construct more complex filters. Defaults to \code{NULL}.}

\item{bbox}{An sf geometry or a boundary box vector of the format
\code{c(xmin, ymin, xmax, ymax)}. Used as a geometric filter to include
only those geometries that relate to \code{bbox} according to the predicate
specified in \code{predicate}. If an sf geometry is provided, coordinates
are automatically transformed to ESPG:25832 (the default CRS), otherwise
they are expected to be in EPSG:25832.}

\item{poly}{An sf geometry. Used as a geometric filter to include
only those geometries that relate to \code{poly} according to the predicate
specified in \code{predicate}. Coordinates are automatically transformed to
ESPG:25832 (the default CRS).}

\item{predicate}{A spatial predicate that is used to relate the output
geometries with the object specified in \code{bbox} or \code{poly}. For
example, if \code{predicate = "within"}, and \code{bbox} is specified,
returns only those geometries that lie within \code{bbox}. Can be one of
\code{"equals"}, \code{"disjoint"}, \code{"intersects"}, \code{"touches"},
\code{"crosses"}, \code{"within"}, \code{"contains"}, \code{"overlaps"},
\code{"relate"}, \code{"dwithin"}, or \code{"beyond"}. Defaults to
\code{"intersects"}.}

\item{geom_property}{Name of the geometry property included in the WFS.
In most cases, this is \code{"geom"}, but there are some exceptions.}

\item{default_crs}{A WFS defines a default CRS in which coordinates for
spatial filtering have to be provided. For BKG services, this is usually
EPSG:25832. All sf objects provided through \code{bbox} or \code{poly} are first
transformed to this CRS before creating the query.}

\item{lang}{Query language to use for constructing the query. One of
\code{"cql"} and \code{"xml"}. By default, almost all \code{ffm} functions
use CQL because it is simpler and less prone to errors. However, CQL is
limited in terms of query size. Especially when providing a \code{poly},
URLs can become so long that the WFS server will decline them. XML can be a
valid alternative to construct large queries. Additionally, some services
like the one used by \code{\link{bkg_geonames}} only support XML. If
\code{NULL}, defaults to \code{getOption("ffm_query_language")}.}
}
\value{
A CQL query or an XML query depending on the \code{lang} argument.
}
\description{
Utility functions to construct XML or CQL queries. These functions are the
backend of the \code{filter} argument in the filter capabilities of all
\code{ffm} functions that interact with a WFS (e.g., \code{\link{bkg_admin}},
\code{\link{bkg_clc}} or \code{bkb_geonames}).
}
\examples{
# CQL and XML support mostly the same things
wfs_filter(ags \%LIKE\% "05\%", lang = "cql")
wfs_filter(ags \%LIKE\% "05\%", lang = "xml")

bbox <- c(xmin = 5, ymin = 50, xmax = 7, ymax = 52)
wfs_filter(bbox = bbox, lang = "cql")
wfs_filter(bbox = bbox, lang = "xml")

# Using `filter`, more complex queries can be built
wfs_filter(ars \%LIKE\% "\%0", filter = "regierungs NOT IS NULL")

wfs_filter(
  filter = "<fes:Not>
    <fes:PropertyIsNull>
      <fes:ValueReference>aussprache</fes:ValueReference>
    </fes:PropertyIsNull>
  </fes:Not>",
  lang = "xml"
)
}
