% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espn_potentialpoints.R
\name{espn_potentialpoints}
\alias{espn_potentialpoints}
\title{ESPN Potential Points}
\usage{
espn_potentialpoints(conn, weeks = 1:17)
}
\arguments{
\item{conn}{the list object created by \code{ff_connect()}}

\item{weeks}{a numeric vector for determining which weeks to calculate}
}
\value{
a tibble with the best lineup for each team and whether they were started or not
}
\description{
This function calculates the optimal starters for a given week, using some lineup heuristics.
}
\examples{
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  conn <- espn_connect(season = 2021, league_id = 950665)
  espn_potentialpoints(conn, weeks = 1)
}) # end try
}
}
