% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_rect}
\alias{get_rect}
\alias{get_polr}
\title{Extract Rectangular or Polar Components}
\usage{
get_rect(x)

get_polr(x)
}
\arguments{
\item{x}{A matrix object containing FFT results.}
}
\value{
\itemize{
\item \strong{\code{get_rect}}: A matrix with two columns:
\itemize{
\item \code{re}: The real part of the coefficients.
\item \code{im}: The imaginary part of the coefficients.
}
\item \strong{\code{get_polr}}: A matrix with two columns:
\itemize{
\item \code{mod}: The magnitude of the coefficients.
\item \code{arg}: The phase angle of the coefficients, in radians.
}
}
}
\description{
The \code{get_rect} and \code{get_polr} functions extract specific components from a
\code{fftab} object, representing the Fourier coefficients in either rectangular
or polar form.
}
\examples{
fftab(c(1, 0, -1, 0)) |> get_rect()

fftab(c(1, 0, -1, 0)) |> get_polr()

}
\seealso{
\code{\link[=get_fx]{get_fx()}}, \code{\link[=get_re]{get_re()}}, \code{\link[=get_mod]{get_mod()}}, \code{\link[=to_rect]{to_rect()}}, \code{\link[=to_polr]{to_polr()}}
}
