% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repr.R
\name{to_cplx}
\alias{to_cplx}
\alias{to_rect}
\alias{to_polr}
\title{Convert a \code{fftab} Object Between Representations}
\usage{
to_cplx(x, .keep = "unused")

to_rect(x, .keep = "unused")

to_polr(x, .keep = "unused")
}
\arguments{
\item{x}{A \code{fftab} object.}

\item{.keep}{Specifies which columns to retain. See \code{\link[dplyr:mutate]{dplyr::mutate()}}.}
}
\value{
A modified \code{fftab} object containing the specified representation:
\itemize{
\item \strong{\code{to_cplx()}}: Adds the \code{fx} column for complex values.
\item \strong{\code{to_rect()}}: Adds the \code{re} and \code{im} columns for rectangular components.
\item \strong{\code{to_polr()}}: Adds the \code{mod} and \code{arg} columns for polar components.
}
}
\description{
These functions convert a \code{fftab} object to a specified representation:
\itemize{
\item \strong{\code{to_cplx()}}: Converts to complex representation (\code{fx}).
\item \strong{\code{to_rect()}}: Converts to rectangular representation (\code{re}, \code{im}).
\item \strong{\code{to_polr()}}: Converts to polar representation (\code{mod}, \code{arg}).
}
}
\details{
\itemize{
\item \strong{\code{to_cplx()}}: Converts from rectangular (\code{re}, \code{im}) or polar (\code{mod}, \code{arg}) components to complex form.
\item \strong{\code{to_rect()}}: Converts from complex (\code{fx}) or polar components to rectangular form.
\item \strong{\code{to_polr()}}: Converts from complex (\code{fx}) or rectangular components to polar form.
}
}
\examples{
fftab(c(1, 0, -1, 0)) |> to_cplx()

fftab(c(1, 0, -1, 0)) |> to_rect()

fftab(c(1, 0, -1, 0)) |> to_polr()

}
\seealso{
\code{\link[=has_cplx]{has_cplx()}}, \code{\link[=get_repr]{get_repr()}}
}
