% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgeo_topography.R
\name{fgeo_topography}
\alias{fgeo_topography}
\alias{fgeo_topography.data.frame}
\alias{fgeo_topography.list}
\title{Create topography data: convexity, slope, and mean elevation.}
\usage{
fgeo_topography(elev, ...)

\method{fgeo_topography}{data.frame}(
  elev,
  gridsize,
  xdim = NULL,
  ydim = NULL,
  edgecorrect = TRUE,
  ...
)

\method{fgeo_topography}{list}(elev, gridsize, edgecorrect = TRUE, ...)
}
\arguments{
\item{elev}{One of these:
\itemize{
\item A dataframe containing elevation data, with columns \code{gx}, \code{gy}, and
\code{elev}, or \code{x}, \code{y}, and \code{elev} (e.g. \code{fgeo.x::elevation$col}).
\item A ForestGEO-like elevation list with elements \code{xdim} and \code{ydim} giving
plot dimensions, and element \code{col} containing a dataframe as described in
the previous item (e.g. \code{fgeo.x::elevation}).
}}

\item{...}{Other arguments passed to methods.}

\item{gridsize}{Number giving the size of each quadrat for which a habitat
is calculated. Commonly, \code{gridsize = 20}.}

\item{xdim, ydim}{(Required if \code{elev} is a dataframe) \code{x} and \code{y}
dimensions of the plot.}

\item{edgecorrect}{Correct convexity in edge quadrats?}
}
\value{
A dataframe of subclass fgeo_topography.
}
\description{
Create topography data: convexity, slope, and mean elevation.
}
\section{Acknowledgment}{

Thanks to Jian Zhang for reporting a bug (issue 59).
}

\examples{
assert_is_installed("fgeo.x")

elev_list <- fgeo.x::elevation
fgeo_topography(elev_list, gridsize = 20)

elev_df <- elev_list$col
fgeo_topography(elev_df, gridsize = 20, xdim = 320, ydim = 500)
}
\seealso{
\code{\link[=fgeo_habitat]{fgeo_habitat()}}.

Other habitat functions: 
\code{\link{fgeo_habitat}()},
\code{\link{tt_test}()}

Other functions to construct fgeo classes: 
\code{\link{fgeo_habitat}()}
}
\author{
This function wraps code by Richard Condit.
}
\concept{functions to construct fgeo classes}
\concept{habitat functions}
