% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_password_protected.Rmd.R
\name{html_password_protected}
\alias{html_password_protected}
\alias{secret_keeper}
\title{Password protected HTML document}
\usage{
html_password_protected(
  output_format = "rmarkdown::html_document",
  password,
  hint = NULL,
  style = list(),
  bundle = FALSE,
  minified = TRUE,
  preview = FALSE,
  ...
)

secret_keeper(
  output_format = "rmarkdown::html_document",
  password,
  hint = NULL,
  style = list(),
  bundle = FALSE,
  minified = TRUE,
  preview = FALSE,
  ...
)
}
\arguments{
\item{output_format}{An R Markdown format that renders to HTML. By default,
will render to the standard \code{rmarkdown::html_document()} format. You
may pass any arguments to your \code{output_format} as shown below:\preformatted{---
output:
  fidelius::html_password_protected:
    output_format:
      rmarkdown::html_document:
        toc: true
---
}}

\item{password}{Private password to unlock file. If not provided, you will
be asked to supply a password by a prompt if you are working from an
interactive session.}

\item{hint}{Optional public password hint.}

\item{style}{Any number of style options that are configurable via
\code{stylize()}. For example:\preformatted{output:
  fidelius::html_password_protected:
    style:
      button_text: "Open Sesame!"
}}

\item{bundle}{Logical. Should all of the decryption machinery and
dependencies be bundled into the HTML document? Default is \code{FALSE}.}

\item{minified}{Logical. Should minified versions of JavaScript dependencies
be included? Default is \code{TRUE}.}

\item{preview}{Logical. Set to \code{FALSE} to bypass the encryption and
password protection to render the HTML document specified by
\code{output_format}. See Notes for more details.}

\item{...}{Not currently used.}
}
\value{
R Markdown output format based on \code{output_format} to pass to
\code{rmarkdown::render()}.
}
\description{
An R Markdown output format to encrypt and password protect an HTML
document using \code{charm()}. \code{secret_keeper()} is an alias for
\code{html_password_protected}.
}
\note{
If you hard-code your \code{password} into the YAML header of the document be
careful not to check the R Markdown file into a public version control
repository (e.g. git or GitHub) where the password is stored and visible
in plain-text. Please use this format carefully.

Try using \code{xaringan::infinite_moon_reader()} with \code{preview = TRUE} to
preview your document with automatic reloading of slides on change. When
you are done developing your document, set \code{preview = FALSE} or remove it
from the YAML header entirely to encrypt and password protect your
document.
}
\examples{
\dontrun{
library(rmarkdown)
render("input.Rmd", html_password_protected())
}

}
\seealso{
\code{\link{charm}} for more information on the password protection and
encryption.
}
