% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_viola_records.R
\name{fetch_viola_records}
\alias{fetch_viola_records}
\title{Fetch Records by Year Ranges from Finna API (Including NA Dates)}
\usage{
fetch_viola_records(
  base_query = "*",
  base_filters = c("collection:\\"VIO\\""),
  year_ranges = list(c(0, as.numeric(format(Sys.Date(), "\%Y")))),
  include_na = TRUE,
  limit_per_query = 1e+05,
  total_limit = Inf,
  delay_after_query = 5
)
}
\arguments{
\item{base_query}{The base query string, defaults to "*".}

\item{base_filters}{A character vector of filters for the search, e.g., \code{c('collection:"VIO"')}.}

\item{year_ranges}{A list of numeric vectors specifying year ranges, e.g., \code{list(c(2000, 2005), c(2006, 2010))}.}

\item{include_na}{Whether to include records with missing \code{main_date_str}. Default is \code{TRUE}.}

\item{limit_per_query}{Maximum number of records to fetch per query. Default is 100000.}

\item{total_limit}{Maximum number of records to fetch overall. Default is \code{Inf}.}

\item{delay_after_query}{Delay in seconds between queries. Default is 5.}
}
\value{
A tibble containing all fetched records.
}
\description{
This function fetches records from the Finna API in chunks divided by year ranges, handling missing date values.
}
