% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_finna.R
\name{search_finna}
\alias{search_finna}
\title{Finna Index Search with Total Limit Option}
\usage{
search_finna(
  query = NULL,
  type = "AllFields",
  fields = NULL,
  filters = NULL,
  facets = NULL,
  facetFilters = NULL,
  sort = "relevance,id asc",
  limit = 100,
  lng = "fi",
  prettyPrint = FALSE
)
}
\arguments{
\item{query}{description}

\item{type}{A string specifying the type of search. Options include "AllFields", "Title", "Author", "Subject". Defaults to "AllFields".}

\item{fields}{A vector of fields to be returned in the search results. Defaults to NULL, which returns a standard set of fields.}

\item{filters}{A vector of filter queries to refine the search. Defaults to NULL.}

\item{facets}{A vector specifying which facets to return in the results. Defaults to NULL.}

\item{facetFilters}{A vector of regular expressions to filter facets. Defaults to NULL.}

\item{sort}{A string defining the sort order of the results. Options include:
\itemize{
\item "relevance,id asc" (default)
\item "main_date_str desc" (Year, newest first)
\item "main_date_str asc" (Year, oldest first)
\item "last_indexed desc" (Last modified)
\item "first_indexed desc" (Last added)
\item "callnumber,id asc" (Classmark)
\item "author,id asc" (Author)
\item "title,id asc" (Title)
}}

\item{limit}{An integer specifying the total number of records to return across multiple pages.}

\item{lng}{A string for the language of returned translated strings. Options are "fi" - Finnish, "en-gb" - English, "sv" - Swedish, "se" - Sami. Defaults to "fi" - Finnish.}

\item{prettyPrint}{A logical value indicating whether to pretty-print the JSON response. Useful for debugging. Defaults to FALSE.}
}
\value{
A tibble containing the search results with relevant fields extracted and provenance information.
}
\description{
This function retrieves records from the Finna index with an option to limit the total number of records returned.
The function paginates through the results, fetching records until the specified total limit is reached.
}
\examples{
search_results <- search_finna("sibelius", sort = "main_date_str desc", limit = 100)
print(search_results)
}
