% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_publisher.R
\name{search_publisher}
\alias{search_publisher}
\title{Finna Publisher Search}
\usage{
search_publisher(
  query = NULL,
  limit = 100,
  lng = "fi",
  filters = NULL,
  prettyPrint = FALSE
)
}
\arguments{
\item{query}{A string specifying the search query.}

\item{limit}{An integer specifying the total number of records to return.}

\item{lng}{A string for the language of returned translated strings. Defaults to "fi".}

\item{filters}{A vector of filter queries to refine the search. Defaults to NULL.}

\item{prettyPrint}{A logical value indicating whether to pretty-print the JSON response. Defaults to FALSE.}
}
\value{
A tibble containing the record IDs and their respective publishers.
}
\description{
This function retrieves only the publisher information from the Finna index based on the search query.
}
\examples{
publishers <- search_publisher("sibelius", limit = 10)
print(publishers)
}
