% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{border_da_trans_cap_SE1_FI_planned}
\alias{border_da_trans_cap_SE1_FI_planned}
\title{Day-ahead transmission capacity SE1-FI - planned}
\usage{
border_da_trans_cap_SE1_FI_planned(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 1 h and unit type MW.
}
\description{
Planned day-ahead transmission capacity from North-Sweden (SE1) to Finland (FI). Transmission capacity is given hourly for every next week hour. Each week's hour is given one value. Planned weekly transmission capacity Fingrid will publish every Tuesday. Information will be updated if there are changes to the previous plan timetable or capacity. Transmission capacity mean the capability of the electricity system to supply electricity to the market without compromising the system security.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- border_da_trans_cap_SE1_FI_planned(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/142
}
