% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{fcr_n_activated}
\alias{fcr_n_activated}
\title{Frequency Containment Reserve for Normal operation, activated}
\usage{
fcr_n_activated(start_time_utc = NA, end_time_utc = NA, user_key = NA)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 15 min and unit type MW.
}
\description{
The values in the data have been erroneously instantaneous values. From February 21, 2024, the data are correct 15-minute averages.Hourly values can be found correctly on the European transparency platform: https://transparency.entsoe.eu/balancing/r2/activationAndActivatedBalancingReserves/show Activated Frequency Containment Reserve for Normal operation (FCR-N) is published one hour after the hour in question, for example the value for hour 07-08 is published at 9 o'clock. FCR-N is the frequency containment reserve used in the Nordic synchronous system that aims to keep the frequency in normal frequency range between 49,9 - 50,1 Hz. Activated FCR-N volume (MWh) is calculated on the basis of the frequency in the Nordic synchronous system and maintained Finnish FCR-N capacity. Value is activated net average power. Positive value means that the frequency has been in average below 50,0 Hz during the hour, and reserve has been activated as up-regulation. Respectively, negative value means that the frequency has been in average above 50,0 Hz, and reserve has been activated as down-regulation. The Data before 13.06.2023 is in hourly resolution.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- fcr_n_activated(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/123
}
