% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sign_up.R
\name{sign_up}
\alias{sign_up}
\title{Sign up with email/password}
\usage{
sign_up(email, password)
}
\arguments{
\item{email}{The email for the user to create.}

\item{password}{The password for the user to create.}
}
\value{
A named list with the following items:
\itemize{
\item \code{idToken}: A Firebase Auth ID token for the newly created user.
\item \code{email}: The email for the newly created user.
\item \code{refreshToken}: A Firebase Auth refresh token for the newly created user.
\item \code{expiresIn}: The number of seconds in which the ID token expires.
\item \code{localId}: The uid of the newly created user.
\item \code{error}:
\itemize{
\item \code{NULL} if no error code in response
\item A list of 2 if response was an error:
\itemize{
\item \code{code}: Error code
\item \code{message}: Error message
}
}
}
}
\description{
Sign up with email/password
}
\details{
Visit \href{https://firebase.google.com/docs/reference/rest/auth#section-create-email-password}{Firebase Auth REST API docs}
for more details
}
\examples{
\dontrun{
  sign_up(email = "new-user-email", password = "strong-password")
}
}
