% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fire_exp_map_cont.R
\name{fire_exp_map_cont}
\alias{fire_exp_map_cont}
\title{Map exposure with a continuous scale (Deprecated)}
\usage{
fire_exp_map_cont(exposure, aoi, title = "Wildfire Exposure")
}
\arguments{
\item{exposure}{SpatRaster from \code{\link[=fire_exp]{fire_exp()}}}

\item{aoi}{(Optional) SpatVector of an area of interest to mask the exposure}

\item{title}{(Optional) String. A custom title for the plot. The default
is \code{"Wildfire Exposure"}}
}
\value{
a map is returned as a ggplot object
}
\description{
This function still works, but will be removed in future
versions of the package. The same functionality is now included in
\code{\link[=fire_exp_map]{fire_exp_map()}}. .
}
\details{
This function returns a standardized map with basic cartographic elements.
The exposure values are mapped using a continuous scale. There is no base
map added with this function.

The plot is returned as a ggplot object which can be exported/saved to
multiple image file formats.
\subsection{Spatial Reference}{

The map will be drawn using the same CRS as the input data.
}
}
\examples{
# read example hazard data
hazard_file_path <- "extdata/hazard.tif"
hazard <- terra::rast(system.file(hazard_file_path, package = "fireexposuR"))

# Compute exposure
exposure <- fire_exp(hazard)

fire_exp_map_cont(exposure)

}
\seealso{
\code{\link[=fire_exp_map_class]{fire_exp_map_class()}}
}
