% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinfK_scatterhist.R
\name{LinfK_scatterhist}
\alias{LinfK_scatterhist}
\title{Linf/K scatterplot of bootstrapping results}
\usage{
LinfK_scatterhist(
  res,
  Linf.breaks = "Sturges",
  K.breaks = "Sturges",
  gridsize = rep(151, 2),
  H = NULL,
  shading = TRUE,
  shading.cols = NULL,
  dens.contour = TRUE,
  probs = c(25, 50, 75, 95),
  phi.contour = TRUE,
  phi.levels = NULL,
  phi.contour.col = 8,
  phi.contour.lty = 2,
  phi.contour.lwd = 1,
  phi.contour.labcex = 0.75,
  pt.pch = 16,
  pt.col = adjustcolor(1, 0.25),
  pt.cex = 0.5,
  pt.bg = 4,
  xlab = expression(italic("L")[infinity]),
  ylab = expression(italic("K")),
  ...
)
}
\arguments{
\item{res}{Object of class \code{data.frame}, \code{tbl_df}, \code{lfqBoot}
or \code{grotagBoot}.}

\item{Linf.breaks, K.breaks}{Arguments passed to \link[graphics]{hist}
function to compute the breakpoints (argument \code{breaks}) for Linf and K
histograms respectively.}

\item{gridsize}{\code{numeric} 2-length vector specifying the resolution of
the grid.}

\item{H}{Plug-in bandwidth object from \code{\link[ks]{Hpi}} (Default:
\code{H = ks::Hpi(res[,c("Linf", "K")])})}

\item{shading}{\code{logical}. Do you want to colour 2D field of density
estimates? (Default \code{TRUE})}

\item{shading.cols}{Colors or color palette used for background shading of 2D
field of density estimates. No considered if \code{shading = FALSE}.}

\item{dens.contour}{\code{logical}. Do you want to add contour lines?
(\code{TRUE} by default).}

\item{probs}{\code{numeric} Density probability cutoffs (in %) to be plotted
by contours. By default \code{probs = c(25, 50, 75, 95)} and not considered
if \code{dens.contour = FALSE}.}

\item{phi.contour}{\code{logical}. Do you want to display phi prime isolines?
(\code{FALSE} by default)}

\item{phi.levels}{\code{numeric} vector that controls Phi prime values.
Omitted if \code{phi.contour = FALSE} and if \code{NULL} values will be
chosen automatically by the \link[graphics]{contour} function.}

\item{phi.contour.col, phi.contour.lty, phi.contour.lwd, phi.contour.labcex}{Extra
arguments used to control the color, line type, line width and labels size of
the phi prime contour isolines.}

\item{pt.pch, pt.col, pt.cex, pt.bg}{Extra arguments to control type, color,
size and background color of resampling points.}

\item{xlab, ylab}{Labels for X and Y axis respectively.}

\item{...}{Extra arguments passed to main plot function.}
}
\value{
This function returns just the described plot.
}
\description{
This function plots a scatterplot of von Bertalanffy growth function
parameters \eqn{K} vs \eqn{L_{inf}} (“Kimura plot”)  with histograms.
}
\details{
Isolines of growth performance (\eqn{Phi’}) can be plotted, as well as
bivariate 95% (and 25%, 50%, and 75%) confidence contour envelopes. The input
used for plotting is usually the result of a bootstrapped growth analysis
(i.e. a \code{lfqBoot} object generated by \strong{fishboot} functions such
as \link{ELEFAN_SA_boot}, \link{ELEFAN_GA_boot}, \link{grotag_boot}, or
\link{grolenage_boot}).

If NULL, it will be defined as \code{colorRampPalette(c("white", blues9))(1e3)}.
}
\examples{
data(alba_boot) # lfqBoot object
LinfK_scatterhist(res = alba_boot)

data(bonito_boot) # grotagBoot object
LinfK_scatterhist(res = bonito_boot)
}
