% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{readAxiomSummary}
\alias{readAxiomSummary}
\title{convert an Affymetrix AxiomCT1.summary file to the import format
for fitPoly}
\usage{
readAxiomSummary(AXdata, markergroups=list(),
out, filetype=c("dat", "RData")[2])
}
\arguments{
\item{AXdata}{name of an AxiomCT1.summary.txt tab-separated text file
exported from Affymetrix Power Tools (APT); or a data.frame in the same
format:\cr
the file may start with a number of comment lines (starting with "#")
followed by a header line of which the first caption is "probeset_id" and all
other captions are sample names, all ending with ".CEL". For each marker there
are two lines, with probeset_id ending in "-A" and "-B"; the two lines for
each marker are consecutive. In addition there may be any number of control
markers, for each of which there is only one line, with probeset_id ending
in "-A".}

\item{markergroups}{a list with character vectors of marker names, or integer
vectors of marker numbers in file order. If the data set is large, the
conversion to long format may exceed memory limits. In these cases the data
can be split into marker groups that are converted separately and each saved
to a file (or returned as list items, but if that is possible splitting into
groups would not be needed)}

\item{out}{the name of an output file (without extension). If a list of
markergroups is given, out must be a valid file name (without extension);
in that case multiple output files are created with filenames in which
the list element numbers are appended to out. If no markergroups are specified
out may also be set to "" or NA; in that case no file is created and the
converted data are only returned as function result.\cr
If out is not "" or NA, then also a file <out>_meanR.dat is saved with for
all samples their mean R value and  number of missing data (over all markers)}

\item{filetype}{either "dat" or "RData" (default): the former produces
tab-separated text files, the latter saves RData files with the converted
data in a data frame with name "dat"}
}
\value{
If no markergroups are specified, a data.frame is returned with
columns MarkerName, SampleName, X, Y, R (= X + Y), ratio (= Y / (X+Y) ).\cr
If a list of markergroups is specified the function result is NULL
and the converted data.frames are only saved as files.\cr
If the saved files are RData files, they all contain one data.frame named
"dat".
}
\description{
An Affymetrix AxiomCT1.summary.txt file in wide format (samples
side-by-side) is converted to a fitPoly input file in long format
}
\details{
The wide-format input is converted to a long-format form with
columns MarkerName, SampleName, X, Y, R (= X + Y) and ratio (= Y / R).
The X and Y signal intensities are obtained from the <marker>-A and <marker>-B
rows in the input data, R and ratio are calculated from these values.
}
