% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{splitNrenameSamples}
\alias{splitNrenameSamples}
\title{Rename samples from array codes to user codes, and split diploid
from polyploid samples}
\usage{
splitNrenameSamples(dat, sampletable, SampleID, CustomerID,
Ploidy=NULL, out, filetype=c("dat","RData")[2])
}
\arguments{
\item{dat}{a data frame in "long" format as returned by readFullDataTable or
readAxiomSummary}

\item{sampletable}{a data frame with at least the columns for SampleID,
CustomerID and Ploidy (these columns may have any name, specified by the
next parameters)}

\item{SampleID}{the title of the column in sampletable containing the codes
for the samples in the array file - there must be a one-to-one relation
between the array codes and the user codes!}

\item{CustomerID}{the title of the column in sampletable containing the
user codes for the samples - there must be a one-to-one relation between the
array codes and the user codes!}

\item{Ploidy}{the title of the column in sampletable containing the ploidy
of the samples; default NULL means no split based on ploidy must be done. If not
NULL, for each different ploidy a separate data.frame will be created and
samples with ploidy missing or "" will be omitted from all files.}

\item{out}{the base filename of the output files; to this will be appended the
the ploidy level(s) if Ploidy is not NULL, and an extension .dat or .RData,
depending on filetype). Setting out to NA or "" results in no output file(s)
being created}

\item{filetype}{either "dat" or "RData" (default): the former produces tab-
separated text files (one for each element of the return value),
the latter saves one RData file containing a list named dat, identical
to the return value}
}
\value{
if Ploidy not specified, the original dat data.frame with substituted
SampleNames; if Ploidy specified a list with one
element for each different value in the Ploidy column; the names of the
elements are then these ploidy values. Each element is a subset of the
original dat data.frame containing only the rows with samples of that ploidy,
and with substituted SampleNames
}
\description{
After conversion of array data to fitPoly format, this function
replaces the array codes for the samples to user codes, and it splits the
data into a part for diploid and one for polyploid samples if both are present.
}
