% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bhattacharya_method.R
\name{align_pot_B}
\alias{align_pot_B}
\title{Align potential values}
\usage{
align_pot_B(resultB, n = 200, digits = 2, linear = TRUE, ...)
}
\arguments{
\item{resultB}{Result from \code{\link[=path_integral_B]{path_integral_B()}}.}

\item{n}{The number of equally spaced points in each axis, at which the landscape is to be estimated.}

\item{digits}{Currently, the raw sample points in some regions are too dense that may crashes interpolation. To avoid this problem, only one point of all with the  same first several digits. is kept. Use this parameter to indicate how many digits are considered. Note that this is a temporary solution and might be changed in the near future.}

\item{linear}{logical – indicating whether linear or spline interpolation should be used.}

\item{...}{Other parameters passed to \code{\link[akima:interp]{akima::interp()}}}
}
\value{
list with 3 components:
  \item{x,y}{
    vectors of x- and y- coordinates of output grid, the same as the input
    argument \code{xo}, or \code{yo}, if present.  Otherwise, their
    default, a vector 40 points evenly spaced over the range of the
    input \code{x}.}
  \item{z}{
    matrix of fitted z-values.  The value \code{z[i,j]} is computed
    at the x,y point \code{xo[i], yo[j]}. \code{z} has
    dimensions \code{length(xo)} times \code{length(yo)}.}

  If input is a \code{SpatialPointsDataFrame} a
  \code{SpatialPixelssDataFrame} is returned.
}
\description{
So that all path-potentials end up at same global min and then generate potential surface with interpolation on a grid.
}
\keyword{internal}
