% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch-player-details.R
\name{fetch_player_details}
\alias{fetch_player_details}
\alias{fetch_player_details_afl}
\alias{fetch_player_details_afltables}
\alias{fetch_player_details_footywire}
\title{Fetch Player Details}
\usage{
fetch_player_details(
  team = NULL,
  season = NULL,
  current = TRUE,
  comp = "AFLM",
  source = "AFL",
  ...
)

fetch_player_details_afl(
  season = NULL,
  team = NULL,
  current = TRUE,
  comp = "AFLM",
  official_teams = FALSE
)

fetch_player_details_afltables(team = NULL)

fetch_player_details_footywire(team = NULL, current = TRUE)
}
\arguments{
\item{team}{team the player played for in the season for, defaults to NULL which returns all teams}

\item{season}{Season in YYYY format}

\item{current}{logical, return the current team list for the current calendar year or all historical data}

\item{comp}{One of "AFLM" (default) or "AFLW"}

\item{source}{One of "AFL" (default), "footywire", "afltables"}

\item{...}{Optional parameters passed onto various functions depending on source.}

\item{official_teams}{boolean, defaults to FALSE. Indicates if we should match \code{team} to the official list from the API. If this is TRUE, it will use the list from the API and uou can use \code{fetch_teams_afl} to see what these names should be}
}
\value{
A Tibble with the details of the relevant players.
}
\description{
\code{fetch_player_details} returns player details such as date of birth, debut
and other details. The exact details that are returned will depend on which
source is provided.

By default the source used will be the official AFL website.

\code{\link[=fetch_player_details_afl]{fetch_player_details_afl()}}, \code{\link[=fetch_player_details_afltables]{fetch_player_details_afltables()}} and \code{\link[=fetch_player_details_footywire]{fetch_player_details_footywire()}}
can be called directly and return data from the AFL website, AFL Tables and Footywire respectively.

The function will typically be used to return the current team lists. For historical data, you can use the \code{current} argument set to FALSE. This will return all historical data for AFL.com and Footywire data. AFLTables data will always return historical data.
}
\examples{
\dontrun{
# Return data for current Hawthorn players
fetch_player_details("Hawthorn")
fetch_player_details("Adelaide", current = FALSE, comp = "AFLW")
fetch_player_details("GWS", current = TRUE, csource = "footywire")
}

}
\seealso{
\itemize{
\item \link{fetch_player_details_afl} for AFL.com data.
\item \link{fetch_player_details_footywire} for Footywire data.
\item \link{fetch_player_details_footywire} for AFL Tables data.
}
}
\concept{fetch player details functions}
