% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{fulton}
\alias{fulton}
\title{Fulton Fish Market data}
\format{
\code{fulton} is a data frame with 97 observations and 12 variables named \code{t}, \code{day}, \code{price}, \code{qty}, \code{speed2}, \code{wave2}, \code{speed3}, \code{wave3}, \code{price_asian}, \code{price_white}, \code{qty_asian}, \code{qty_white}.
Each row is a recording of the Fulton fish market sales on a given day.
\itemize{
\item t: Time-trend
\item day: Day of the week
\item price: Average price of fish (calculated as \code{(qty_white * price_white + qty_asian * price_asian) / (qty_white + qty_asian)})
\item qty: Quantity of fish sold (calculated as \code{qty_white + qty_asian})
\item speed2: Wind speeds (minimum of past 2 days)
\item wave2:  Maximum wave height (average of last 2 days)
\item speed3: Wind speed (3 day lag)
\item wave3:  Maximum wave height (average of last 3 and 4 day lag)
\item price_asian: Average price of fish sold to Asian customers
\item price_white: Average price of fish sold to White customers
\item qty_asian: Quantity of fish sold to Asian customers
\item qty_white: Quantity of fish sold to White customers
}
}
\source{
https://www.cengage.com/cgi-wadsworth/course_products_wp.pl?fid=M20b&product_isbn_issn=9781111531041
}
\usage{
data(fulton)
}
\description{
This dataset has been taken from Jeff Wooldridge's textbook.
A modified version that appears in the \code{wooldridge} package.
}
\details{
Source: K Graddy (1995), “Testing for Imperfect Competition at the Fulton Fish Market,” RAND Journal of Economics 26, 75-92.
}
\keyword{datasets}
