% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vectors.R
\name{random_datetime_vector}
\alias{random_datetime_vector}
\title{Get random datetime vector}
\usage{
random_datetime_vector(
  size,
  min_date,
  max_date,
  date_format = NULL,
  date_unique = FALSE,
  min_time = "00:00:00",
  max_time = "23:59:59",
  time_resolution = "seconds",
  time_unique = FALSE,
  tz = "UTC"
)
}
\arguments{
\item{size}{integer, vector length}

\item{min_date}{character or date, beginning of the dates interval to sample from}

\item{max_date}{character or date, ending of the dates interval to sample from}

\item{date_format}{character, check \code{\link[base]{strptime}} for details}

\item{date_unique}{boolean, should the date part of the output  be unique?}

\item{min_time}{character, beginning of the time interval to sample from}

\item{max_time}{character, ending of the time interval to sample from}

\item{time_resolution}{character, one of "seconds", "minutes", "hours", time resolution}

\item{time_unique}{boolean, should the time part of the output be unique?}

\item{tz}{character, time zone to use}
}
\description{
Get random datetime vector
}
\examples{
random_datetime_vector(12, "2012-12-04", "2020-10-31", min_time = "7:00:00", max_time = "17:00:00")
}
