% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_marginals_grid.R
\name{plot_marginals_grid}
\alias{plot_marginals_grid}
\title{Facetted histograms of marginals before and after flexIC}
\arguments{
\item{original}{Matrix or data frame of the original variables.}

\item{flex_out}{Either the list returned by \code{flexIC()} or the
transformed numeric matrix itself.}

\item{bins}{Number of histogram bins.}

\item{after_lab}{Facet-strip label for the post-flexIC panel.}
}
\value{
A \link[ggplot2]{ggplot} object (returned invisibly).
}
\description{
Facetted histograms of marginals before and after flexIC
}
\examples{
\donttest{
  set.seed(1)
  x  <- matrix(rnorm(300), ncol = 3)
  target <- cor(x, method = "spearman")
  fo <- flexIC(x, target, eps = 0.02, max_iter = 5)
  plot_marginals_grid(x, fo, bins = 30)
}

}
