% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q.matr.setup.general.R
\name{Q.matr.setup.general}
\alias{Q.matr.setup.general}
\title{Internal function}
\usage{
Q.matr.setup.general(
  params,
  nstates,
  full.X,
  start.pos.par,
  l.short.formula,
  whereQ,
  firstD = TRUE,
  secondD = TRUE,
  bound.eta = FALSE,
  pos.optparams,
  pos.optparams2
)
}
\arguments{
\item{params}{Parameters vector.}

\item{nstates}{Number of states.}

\item{full.X}{Full design matrix.}

\item{start.pos.par}{Positions within full parameters vector of starting point for each sub-parameters vector corresponding to each transition intensity specification.}

\item{l.short.formula}{Number of transitions.}

\item{whereQ}{Positions within Q matrix of not-null transition intensities.}

\item{firstD}{Whether the first derivative of the Q matrix should be computed.}

\item{secondD}{Whether the second derivative of the Q matrix should be computed.}

\item{bound.eta}{Whether to bound the additive predictor, defaults to \code{FALSE}. This is only used for debugging purposes, do not change.}

\item{pos.optparams}{Vector with positions of parameters vector in the form used by the optimization algorithm (i.e. when one or more parameters are constrained to be equal these will only appear once).}

\item{pos.optparams2}{Like \code{pos.optparams} but the count is not stopped at the constrained parameters.}
}
\value{
Q matrix and its first and second derivatives with respect to the parameters vector.
}
\description{
Internal function needed for setup of Q matrix and its first and second derivative.
}
