#' Risk Aversion
#' 
#' Survey data from 563 respondents on frequency of risk taking on six different types.
#' Taken from the companion package to _Market Segmentation Analysis:
#' Understanding It, Doing It, and Making It Useful_ (Dolnicar et al., 2018,
#' \doi{10.1007/978-981-10-8818-6}).
#' 
#' @format
#' A matrix with 563 respondents (rows) and 6 variables (columns) named
#' `Recreational`, `Health`, `Career`, `Financial`, `Safety` and `Social`.
#' 
#' @details
#' The data was collected by academic researchers using a permission based
#' online panel.
#'
#' The sample was taken from adult Australian residents who have undertaken
#' at least one holiday in the last year which involved staying away from
#' home for at least four nights.
#'
#' The respondents were asked: "Which risks have you taken in the past?"
#' and answered on a 5-point scale with options:
#' - Never (1)
#' - Rarely (2)
#' - Quite often (3)
#' - Often (4)
#' - Very often (5)
#' 
#' The six types of risk were:
#' - Recreational: e.g. rock-climbing, scuba diving
#' - Health: e.g., smoking, poor diet, high alcohol consumption
#' - Career: e.g., quitting a job without another to go to
#' - Financial: e.g., gambling, risky investments
#' - Safety: e.g., speeding
#' - Social: e.g., standing for election, publicly challenging a rule or decision
#' 
#' @usage data('risk')
#' 
#' @references
#' - Hajibaba H, Dolnicar S (2017).
#'   *Helping When Disaster Hits*. In: Dolnicar S (ed) Peer-to-Peer Accomodation
#'   Networks: Pushing the Boundaries, Goodfellow Publishers, Oxford, chap.21,
#'   235-243.
#'   \doi{10.23912/9781911396512-3619}
#' - Hajibaba H, Karlsson L, Dolnicar S (2017)
#'   *Residents Open Their Homes to Tourists When Disaster Strikes.*
#'   Journal of Travel Research. 58(8), 1065-1078.
#'   \doi{10.1177/0047287516677167}
#'   
#' @source
#'   Sara Dolnicar.
#'   
#'   Data and help page are taken from the companion package to _Market Segmentation
#'   Analysis: Understanding It, Doing It, and Making It Useful_ (Dolnicar et al., 2018,
#'   \doi{10.1007/978-981-10-8818-6}).
#'
#'   URL: \url{https://statistik.boku.ac.at/nachlass_leisch/MSA/}
"risk"
