% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GHSL-tiles-per-region.R
\docType{data}
\name{GHSL_tiles_per_region}
\alias{GHSL_tiles_per_region}
\title{Division of GHSL tiles in 9 regions}
\format{
\subsection{\code{GHSL_tiles_per_region}}{

A named list of length 9:
\itemize{
\item the names represent the 9 different regions (\code{W_AEA}, \code{W_AME}, \code{W_ISL1}, \code{W_ISL2}, \code{W_ISL3}, \code{W_ISL4}, \code{W_ISL5}, \code{W_ISL6}, \code{W_ANT})
\item the elements are vectors with the GHSL tile ids that make up the regions
}
}
}
\source{
\url{https://ghsl.jrc.ec.europa.eu/download/GHSL_data_54009_shapefile.zip}
}
\usage{
GHSL_tiles_per_region
}
\description{
The Global Human Settlement Layer (GHSL) divides the world into different rectangular tiles. To execute the Degree of Urbanisation in a memory-efficient manner, we grouped these tiles into 9 different regions. These regions are the smallest possible grouping of GHSL tiles, ensuring that no continuous land mass is split across two regions. By splitting the world into different parts, the RAM required to execute the Degree of Urbanisation is optimised. For a concrete example on how to use the regions to construct the grid classification on a global scale, see \code{vignette("vig3-DoU-global-scale")}.

The 9 regions cover approximately the following areas:
\itemize{
\item \strong{W_AEA:} Asia - Europe - Africa - Oceania (eastern hemisphere)
\item \strong{W_AME:} North and South America (+ Greenland and Iceland)
\item \strong{W_ISL1:} Hawaii
\item \strong{W_ISL2:} Oceanic Islands (western hemisphere)
\item \strong{W_ISL3:} Chatham Islands
\item \strong{W_ISL4:} Scott Island
\item \strong{W_ISL5:} Saint-Helena, Ascension and Tristan da Cunha
\item \strong{W_ISL6:} French Southern and Antarctic Lands
\item \strong{W_ANT:} Antarctica
}

\figure{figure_GHSL_tiles_per_region.png}{GHSL tiles}

For more information about the GHSL tiles and their extent see \href{https://ghsl.jrc.ec.europa.eu/download.php}{GHSL Download page}.
}
\keyword{datasets}
