% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_regions_to_grid.R
\name{convert_regions_to_grid}
\alias{convert_regions_to_grid}
\title{Convert regions to a grid}
\usage{
convert_regions_to_grid(regions, referencegrid, id = NULL)
}
\arguments{
\item{regions}{character / object of class sf. Path to the vector layer with spatial regions, or an object of class sf with spatial regions}

\item{referencegrid}{SpatRaster. Reference grid used to rasterize the values of the regions.}

\item{id}{character. The column that contains the values of the regions. If \code{NULL} the first column is used.}
}
\value{
SpatRaster with the regions
}
\description{
Convert the value of regions associated with a vector layer to a grid layer.
}
\examples{
# load data for urban proxies and regions
proxies <- load_proxies_belgium()
regions <- flexurba::units_belgium

# convert Belgian provinces ('GID_2') to a zonal grid
gridded_regions <- convert_regions_to_grid(regions, proxies$pop, "GID_2")
terra::plot(gridded_regions)
}
