% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-adjacent.R
\name{get_adjacent}
\alias{get_adjacent}
\title{Identify adjacent cells}
\usage{
get_adjacent(
  x,
  cells = "all",
  adjacent_value = 1,
  include = TRUE,
  directions = 8
)
}
\arguments{
\item{x}{SpatRaster}

\item{cells}{character / integer. Either \code{"all"} or a specific cell value. If \code{cells="all"}, adjacent cells are identified for all non-\code{NA} cells in \code{x}. Otherwise, adjacent cells are only identified for cells in \code{x} with the specific cell value.}

\item{adjacent_value}{integer. Value assigned to adjacent cells in the resulting grid}

\item{include}{logical. Whether to include the focal cells in the resulting grid}

\item{directions}{integer. Which cells are considered adjacent:  \code{4} for rooks case (horizontal and vertical neighbours) or \code{8} for queens case (horizontal, vertical and diagonal neighbours)}
}
\value{
SpatRaster with adjacent cells
}
\description{
The function identifies all cells that are adjacent to non-\code{NA} cells in \code{x}. The implementation of the function relies on the function \code{terra::adjacent()}.
}
\examples{
set.seed(10)
nr <- nc <- 10
r <- terra::rast(
  ncols = nc, nrows = nr,
  ext = c(0, nc, 0, nr),
  vals = sample(c(NA, 1, 2), nr * nc, replace = TRUE, prob = c(0.8, 0.1, 0.1))
)
terra::plot(r)
adj1 <- get_adjacent(r)
terra::plot(adj1)
adj2 <- get_adjacent(r, cells = 1, include = FALSE)
terra::plot(adj2)
}
