% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_exported_functions.R
\name{chunk_reveal}
\alias{chunk_reveal}
\title{chunk_reveal}
\usage{
chunk_reveal(
  chunk_name = NULL,
  break_type = "auto",
  left_assign = FALSE,
  left_assign_add = NULL,
  lang = "r",
  omit = "#OMIT",
  code_seq = NULL,
  code_seq_lag = NULL,
  code_seq_lag2 = NULL,
  code_seq_target = NULL,
  code_seq_start = NULL,
  func_seq = NULL,
  num_breaks = NULL,
  display_type = c("code", "output"),
  title = "",
  md = NULL,
  md2 = NULL,
  replacements = NULL,
  replace = NULL,
  replacements2 = replacements,
  replace2 = replace,
  replacements3 = replacements,
  replace3 = replace,
  widths = NULL,
  float = "left",
  chunk_options = "",
  color = c("black", "black", "black"),
  font_size_code = "80\%"
)
}
\arguments{
\item{chunk_name}{a character string referring to the name of the source chunk for the flipbooking}

\item{break_type}{"auto" is default finding appropriate breakpoints, "user" can be used with the special comment message #BREAK within the source code chunk, "non_seq" can be used for non sequential display of code with special comment messages #BREAK2 (will show in second frame) and #BREAK3 (will show in third frame), an integer input can be given too, to simply display the source code chunk multiple times which is appropriate for observing multiple realizations of sampling, "rotate" allows cycling through different lines of code, the comment #ROTATE is used for lines to by cycled through}

\item{left_assign}{a logical, default is FALSE, if TRUE will print the object created in the upper left hand corner of the source code chunk at the end of each partial reveal}

\item{left_assign_add}{a character string containing function for table formatting in output, for left assign case only}

\item{lang}{a character string indicating what programming language will be used. "r" is default; "python" is experimental}

\item{omit}{a character string, as a comment, indicating lines that should be omitted, defaults to "#OMIT"}

\item{code_seq}{a list of code as character strings, the list will automatically be created based on the previous three arguments or the user can input code manually}

\item{code_seq_lag}{a list of code as character strings, lagged, the list will automatically be created based on the previous three arguments or the user can input code manually}

\item{code_seq_lag2}{a list of code as character strings, twice lagged, the list will automatically be created based on the previous three arguments or the user can input code manually}

\item{code_seq_target}{a list of code as character strings, the length of code_seq, but only containing the last element of code_seq}

\item{code_seq_start}{a list of code as character strings, the length of code_seq, but only containing the first element of code_seq}

\item{func_seq}{a character string with function names; default is NULL and will reflect whatever function is highlighted from the code sequence}

\item{num_breaks}{an integer, automatically calculated based on the length of the the code_seq list}

\item{display_type}{a character string vector, the default is c("code", "output") for code and output to be displayed side-by-side, "output" will create spawned code chunks to only display output, "code" will create spawned code chunks only to show the partial code builds; "func" and "md" may also be displayed}

\item{title}{a character string that may contain a title for the frames of the flipbook; this may included header info "## My Title" for example is a second level markdown title in Xaringan}

\item{md}{a character string vector that contains markdown; each element will be shown on a separate slide in the display panel "md" (see display_type)}

\item{md2}{a character string vector that contains markdown; each element will be shown on a separate slide in the display panel "md" (see display_type)}

\item{replacements}{a character string vector to be replace the string indicated by the 'replace' parameter}

\item{replace}{a character string to be replaced in the input code sequentially with the replacement vector elements}

\item{replacements2}{a character string vector to be replace the string indicated by the 'replace2' parameter}

\item{replace2}{a character string to be replaced in the input code sequentially with the replacement2 vector elements}

\item{replacements3}{a character string vector to be replace the string indicated by the 'replace3' parameter}

\item{replace3}{a character string to be replaced in the input code sequentially with the replacement3 vector elements}

\item{widths}{a numeric vector containing relative widths for panels}

\item{float}{defines css float parameter, defaults to "left"}

\item{chunk_options}{input 'knitr' code chunk options as a string, default to empty string "", useful input might be "fig.height = 4, fig.width = 3"}

\item{color}{defines css parameter, defaults to "black"}

\item{font_size_code}{this ain't working yet!}
}
\value{
a string object is returned will only work in 'knitr' context
}
\description{
Function takes code from referenced code chunk and returns partial code sequence to series of code chunks separated by slide breaks.  Upon compiling you get step-by-step code walk-through.
}
\examples{
chunk_reveal(chunk_name = NULL, code_seq = list("1 + 1", "1 + 2"))

}
