% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_calculator_data.R
\name{bind_calculator_data}
\alias{bind_calculator_data}
\title{Bind calculator data}
\usage{
bind_calculator_data(
  .,
  questions_data = NULL,
  question_text = NULL,
  question_type = NULL,
  context_text = NULL,
  image = NULL,
  answers_raw = NULL,
  fallback_value = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{questions_data}{Questions data.}

\item{question_text}{Question text. The question text. Flourish type hint: column}

\item{question_type}{Question type. The type of question. Choose from number input, text input, single response buttons, multi response buttons, dropdown, single date picker, range date picker, multi date picker, rating, single slider or range slider. Leave empty to just display text. Flourish type hint: column}

\item{context_text}{Question context. Additional information. Flourish type hint: column}

\item{image}{Image. Question background image. Add an image URL or right-click on a cell to upload an image. Flourish type hint: column}

\item{answers_raw}{Answers. Answer values separated by "::". Required for single and multi-response buttons, dropdown and rating questions. Rating answers can take optional labels per value noted as "Value >> Label" - for example, "1 >> Bad :: 2 :: 3 >> Good". Number inputs can take range specifications in the format "min: 0 :: max: 50 :: step: 2". Slider inputs can take slider specifications in the format "min: 0 :: max: 100 :: value: 10". Use two comma separated values for range sliders, eg.: "value: 1, 100". See the templates documentation for additional info. Flourish type hint: column}

\item{fallback_value}{Fallback value. Fallback value to fill the answer input if left empty by the user. Works for all question types but sliders, which will always show the initial value. Flourish type hint: column}
}
\value{
A Flourish chart
}
\description{
Bind calculator data
}
\examples{
try(
  flourish(chart_type = "calculator", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_calculator_data(gapminder)
)
}
