% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_routine_chargement_cinetique.R
\name{read.kinetic}
\alias{read.kinetic}
\title{Reads a kinetic file, as produced by a Biotek plate reader.}
\usage{
read.kinetic(name, path = NULL, readTime = TRUE, saveData = TRUE)
}
\arguments{
\item{name}{The name of the file to be read}

\item{path}{The path where the file is to be found}

\item{readTime}{Should time data be read?}

\item{saveData}{Should the resulting \code{data.frame} be saved?}
}
\value{
Returns a \code{data.frame} if \code{saveData} is set to \code{FALSE}.
If \code{saveData} is set to \code{TRUE}, the \code{data.frame} is saved and the
file name is returned.
}
\description{
Reads a kinetic file, as produced by a Biotek plate reader.
}
\examples{
## reads data. Warning: files are large, and this operation takes time!
d <- read.kinetic("kinetics_xenorhabdus_galleria.txt",
                     path=system.file('extdata', package = 'fluoSurv'),
                     saveData=FALSE)
str(d)

## saveData should rather be set to TRUE so that converted data are saved
## in a csv file and can be re-used later on.

}
