% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_routine_estimation_t_mort.R
\name{when.threshold}
\alias{when.threshold}
\title{Computes when fluorescence exceeds a given threshold value}
\usage{
when.threshold(t, x, min.t = 5, threshold = 0.1, n = 50)
}
\arguments{
\item{t}{The time value}

\item{x}{The fluorescence value}

\item{min.t}{The time value after which threshold value is searched}

\item{threshold}{Threshold value, as a proportion above the maximum intensity value observed before min.t}

\item{n}{Width of the moving average window used to smooth signal}
}
\description{
Computes when fluorescence exceeds a given threshold value
}
\examples{

data(galleria)
d <- subset(galleria,!is.na(value))
l  <- lapply(split(d,d$well),extract.well)   #complete kinetics for each well

with(l[["A3"]],plot(t_2_485_535,log(value_2_485_535,10),type="l"))
with(l[["A3"]],abline(v=when.threshold(t_2_485_535,value_2_485_535)))

}
