% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{fmpc_economic_results}
\alias{fmpc_economic_results}
\title{Economic results}
\usage{
fmpc_economic_results(
  event = "adpEmploymentChange",
  country = "US",
  startDate = Sys.Date() - 180,
  endDate = Sys.Date()
)
}
\arguments{
\item{event}{an economic event from \code{\link{fmpc_economic_events}}}

\item{country}{a country from \code{\link{fmpc_economic_events}}}

\item{startDate}{filter start date in yyyy-mm-dd format.}

\item{endDate}{filter end date in yyyy-mm-dd format.}
}
\value{
calendar events
}
\description{
Shows the results of the economic events from
\code{\link{fmpc_economic_events}}
}
\examples{

\dontrun{

# Must set a valid API token
fmpc_set_token('FMPAPIKEY')
Events = fmpc_economic_events()
fmpc_economic_results()

# Italy three month interbank rate
fmpc_economic_results(event = Events[100,1], country = Events[100,2])

# Consumer credit - RS
fmpc_economic_results(event = Events[1000,1], country = Events[1000,2])


}
}
