% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/financials.R
\name{fmpc_financial_metrics}
\alias{fmpc_financial_metrics}
\title{Get financial metrics for one or more tickers}
\usage{
fmpc_financial_metrics(
  symbols = "AAPL",
  metric = c("ratios", "key", "ev", "growth"),
  quarterly = TRUE,
  trailingTwelve = FALSE,
  limit = 100
)
}
\arguments{
\item{symbols}{one or more publicly traded companies domestic or
international}

\item{metric}{indicate the statement to view. Can be 'income', 'balance',
or 'cashflow'}

\item{quarterly}{TRUE/FALSE whether the statement should be shown quarterly
or annually}

\item{trailingTwelve}{TRUE/FALSE whether finance ratios should show as
trailing 12 months. Only available for finance ratios.}

\item{limit}{limit the result for each ticker}
}
\value{
data frame of financial metrics
}
\description{
Pull finance ratios, enterprise value, key metrics, and financial growth
}
\examples{


\dontrun{

 # Setting API key to 'demo' allows for AAPL only
fmpc_set_token()
fmpc_financial_metrics()
fmpc_financial_metrics('AAPL',metric = 'ratios', quarterly = FALSE,
                     trailingTwelve = FALSE, limit = 10)

# Must set a valid API token
fmpc_set_token('FMPAPIKEY')
fmpc_financial_metrics(c('AAPL','MSFT','TSLA'))

# International tickers work
fmpc_financial_metrics('RY.TO',metric = 'key', quarterly = TRUE,
                     trailingTwelve = TRUE, limit = 10)



}
}
