% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf-functions.R
\name{hrf_fourier}
\alias{hrf_fourier}
\title{Fourier basis for HRF modeling}
\usage{
hrf_fourier(t, span = 24, nbasis = 5)
}
\arguments{
\item{t}{A vector of time points.}

\item{span}{The temporal window over which the basis functions span (default: 24).}

\item{nbasis}{The number of basis functions (default: 5). Should be even for full sine-cosine pairs.}
}
\value{
A matrix of Fourier basis functions with nbasis columns.
}
\description{
Generates a set of Fourier basis functions (sine and cosine pairs) over a given span.
}
\examples{
# Create Fourier basis with 5 functions
t <- seq(0, 24, by = 0.5)
basis <- hrf_fourier(t, span = 24, nbasis = 5)
matplot(t, basis, type = "l", main = "Fourier Basis Functions")
}
