% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnets.R
\name{network.fnets}
\alias{network.fnets}
\title{Convert networks estimated by fnets into igraph objects}
\usage{
\method{network}{fnets}(
  object,
  type = c("granger", "pc", "lrpc"),
  names = NA,
  groups = NA,
  group.colours = NA,
  ...
)
}
\arguments{
\item{object}{\code{fnets} object}

\item{type}{a string specifying which of the above three networks (i)--(iii) to visualise; possible values are
\describe{
   \item{\code{"granger"}}{ directed network representing Granger causal linkages}
   \item{\code{"pc"}}{ undirected network representing contemporaneous linkages; available when \code{object$do.lrpc = TRUE}}
   \item{\code{"lrpc"}}{ undirected network summarising Granger causal and contemporaneous linkages; available when \code{x$do.lrpc = TRUE}}
}}

\item{names}{a character vector containing the names of the vertices}

\item{groups}{an integer vector denoting any group structure of the vertices}

\item{group.colours}{a vector denoting colours corresponding to \code{groups}}

\item{...}{additional arguments to \code{igraph::graph_from_adjacency_matrix}}
}
\value{
a list containing
\item{network}{ \code{igraph} object}
\item{names}{ input argument}
\item{groups}{ input argument}
\item{grp.col}{ vector of colours corresponding to each node}
\item{...}{ additional arguments to \code{igraph::graph_from_adjacency_matrix}}
}
\description{
Converts S3 objects of class \code{fnets} into a network.
Produces an igraph object for the three networks underlying factor-adjusted VAR processes:
(i) directed network representing Granger causal linkages, as given by estimated VAR transition matrices summed across the lags,
(ii) undirected network representing contemporaneous linkages after accounting for lead-lag dependence, as given by partial correlations of VAR innovations,
(iii) undirected network summarising (i) and (ii) as given by long-run partial correlations of VAR processes.
When plotting the network, note that the edge weights may be negative since they correspond to the entries of the estimators of VAR parameters and (long-run) partial correlations.
}
\examples{
\donttest{
out <- fnets(data.unrestricted,
  do.threshold = TRUE,
  var.args = list(n.cores = 2)
)
net <- network(out, type = "granger")$network
plot(net, layout = igraph::layout_in_circle(net))
network(out, type = "pc")
network(out, type = "lrpc")
}
}
\seealso{
\link[fnets]{fnets}, \link[fnets]{plot.fnets}
}
