% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotopes.R
\docType{data}
\name{epica2008}
\alias{epica2008}
\title{EPICA Dome C}
\format{
A \code{data.frame} with 1096 observations and 2 variables:
\describe{
\item{age}{\code{\link{integer}}: year BP.}
\item{CO2}{\code{\link{numeric}}: \eqn{CO_2}{CO2} (ppmv).}
}
}
\source{
\url{https://www.ncei.noaa.gov/access/paleo-search/study/6091}
}
\usage{
epica2008
}
\description{
EPICA Dome C 800-ka composite \eqn{CO_2}{CO2} data.
}
\examples{
plot(
  x = epica2008$age / 1000,
  y = epica2008$CO2,
  type = "l",
  xlim = c(800, 0),
  xlab = "kilo year BP",
  ylab = expression("CO"[2]~"(ppmv)")
)
}
\references{
Lüthi, D., Le Floch, M., Bereiter, B., Blunier, T., Barnola, J.-M.,
Siegenthaler, U., Raynaud, D., Jouzel, J., Fischer, H., Kawamura, K. and
Stocker, T. F. (2008). High-resolution carbon dioxide concentration record
650,000-800,000 years before present. \emph{Nature}, 453, 379-382.
\doi{10.1038/nature06949}

Monnin, E., Indermuhle, A., Dallenbach, A., Fluckiger, J., Stauffer, B.,
Stocker, T. F., Raynaud, D. and Barnola, J.-M. (2001). Atmospheric CO2
concentrations over the last glacial termination. \emph{Science}, 291,
112-114. \doi{10.1126/science.291.5501.112}

Petit, J. R., Jouzel, J., Raynaud, D., Barkov, N. I., Barnola, J.-M.,
Basile, I., Benders, M., Chappellaz, J., Davis, M., Delayque, G.,
Delmotte, M., Kotlyakov, V. M., Legrand, M., Lipenkov, V. Y.,
Lorius, C., Pepin, L., Ritz, C., Saltzman, E. and Stievenard, M. (1999).
Climate and atmospheric history of the past 420,000 years from the Vostok
ice core, Antarctica. \emph{Nature}, 399, 429-436. \doi{10.1038/20859}

Siegenthaler, U., Stocker, T. F., Monnin, E., Luthi, D., Schwander, J.,
Stauffer, B., Raynaud, D., Barnola, J.-M., Fischer, H., Masson-Delmotte, V.,
Jouzel, J. (2005). Stable Carbon Cycle-Climate Relationship During the Late
Pleistocene. \emph{Science}, 310, 1313-1317. \doi{10.1126/science.1120130}
}
\seealso{
Other palaeoenvironment data: 
\code{\link{law2006}},
\code{\link{lisiecki2005}},
\code{\link{ngrip2004}},
\code{\link{ngrip2010}},
\code{\link{spratt2016}}
}
\concept{palaeoenvironment data}
\keyword{datasets}
