% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foodweb.R
\name{foodweb}
\alias{foodweb}
\title{Create a foodweb}
\usage{
foodweb(
  FUN = NULL,
  env = parent.frame(),
  filter = !is.null(FUN),
  as.text = FALSE
)
}
\arguments{
\item{FUN}{A function.}

\item{env}{An environment, \code{parent.frame()} by default. Ignored if \code{FUN} is not \code{NULL}.}

\item{filter}{Boolean. If \code{TRUE}, only functions that are direct descendants or antecedents of
\code{FUN} will be shown.}

\item{as.text}{Boolean. If \code{TRUE}, rather than rendering the graph the intermediate graphviz
specification is returned.}
}
\value{
If \code{as.text} is \code{TRUE}, a character vector. Otherwise, a \code{foodweb} object as described
above.
}
\description{
A \code{foodweb} object describes the relationship of functions in an environment. It has two
components: \code{funmat} (function matrix) which encodes the caller/callee relationships (i.e. which
functions call which) and \code{graphviz_spec} which is a text representation of the graph and is used
for the default plotting behaviour.
}
\details{
\code{foodweb()} looks at the global environment by default. If you want to look at another
environment you can either pass a function to the \code{FUN} argument of \code{foodweb()} or pass an
environment to the \code{env} argument. If \code{FUN} is provided then the value of \code{env} is ignored, and
the environment of \code{FUN} will be used.
}
\examples{
# Create some functions to look at
f <- function() 1
g <- function() f()
h <- function() {
  f()
  g()
}
i <- function() {
  f()
  g()
  h()
}
j <- function() j()

x <- foodweb()
x

# You can access the components directly or via getter functions
x$funmat
get_graphviz_spec(x)

# Calculate the foodweb of a function in another package
foodweb(glue::glue)
}
